# 🚀 راهنمای نصب سریع ربات گیفت الرت

## 📋 پیش‌نیازها

- **PHP 8.1+** نصب شده باشد
- **Composer** برای مدیریت وابستگی‌ها
- **حساب Telegram API** (api_id و api_hash)
- **اتصال اینترنت** پایدار

## ⚡️ نصب سریع (5 دقیقه)

### گام 1: دانلود و آماده‌سازی
```bash
# کلون پروژه
git clone https://github.com/your-username/gift-alert-bot.git
cd gift-alert-bot

# یا دانلود مستقیم
# فایل‌ها را در یک پوشه کپی کنید
```

### گام 2: تنظیم API Keys
فایل `config.php` را باز کنید و مقادیر زیر را تغییر دهید:

```php
'telegram' => [
    'api_id' => YOUR_API_ID,        // جایگزین کنید
    'api_hash' => 'YOUR_API_HASH',  // جایگزین کنید
    // ...
],
```

### گام 3: اجرای راه‌انداز
```bash
php start.php
```

### گام 4: شروع ربات
```bash
php gift_alert_bot.php
```

## 🔧 تنظیمات پیشرفته

### تغییر فاصله چک گیفت‌ها
در فایل `config.php`:
```php
'monitoring' => [
    'check_interval' => 3.0, // ثانیه (پیشفرض: 3)
    // ...
],
```

### فعال/غیرفعال کردن ویژگی‌ها
```php
'notifications' => [
    'hourly_status' => true,     // گزارش ساعتی
    'daily_summary' => true,     // خلاصه روزانه
    'duplicate_prevention' => true, // جلوگیری از تکرار
    // ...
],
```

## 📱 تست ربات

1. در تلگرام، ربات خود را استارت کنید
2. دستور `/start` را بفرستید
3. برای عضویت `@me` را ارسال کنید
4. منتظر اطلاعیه‌های گیفت باشید!

## 🛠 دستورات مفید

```bash
# نمایش وضعیت ربات
php manage.php status

# ایجاد بک‌آپ
php manage.php backup

# مشاهده آمار
php manage.php stats

# پاک‌سازی لاگ‌ها
php manage.php clean
```

## 🚨 رفع مشکلات رایج

### خطای Permission Denied
```bash
chmod 755 data logs backup temp
```

### خطای Memory Limit
در فایل `config.php`:
```php
'performance' => [
    'memory_limit' => '512M', // افزایش حافظه
    // ...
],
```

### خطای API Rate Limit
فاصله چک را افزایش دهید:
```php
'monitoring' => [
    'check_interval' => 10.0, // 10 ثانیه
    // ...
],
```

## 📞 پشتیبانی

اگر مشکلی داشتید:
1. فایل `logs/bot.log` را بررسی کنید
2. دستور `php manage.php status` را اجرا کنید
3. در [Issues](https://github.com/your-username/gift-alert-bot/issues) پروژه سوال کنید

## ✅ موفقیت!

اگر همه چیز درست پیش رفته:
- ربات باید پیام "ربات شروع به کار کرد" را نشان دهد
- هر ساعت گزارش وضعیت ارسال می‌شود
- گیفت‌های جدید فوری اطلاع‌رسانی می‌شوند

🎉 **تبریک! ربات شما آماده است!**
