<?php

// تنظیمات پیشرفته ربات گیفت الرت

return [
    // تنظیمات اصلی ربات
    'bot' => [
        'name' => 'Ultra Gift Alert Bot',
        'version' => '2.0.0',
        'author' => 'LiveProto Developer',
        'description' => 'ربات هوشمند اطلاع‌رسانی گیفت‌های تلگرام',
    ],
    
    // تنظیمات API تلگرام
    'telegram' => [
        'api_id' => ,
        'api_hash' => '',
        'device_model' => 'PC 64bit Ultra',
        'system_version' => '4.14.186',
        'app_version' => '1.28.5',
        'use_ipv6' => false,
        'hide_logs' => true,
        'receive_updates' => false,
    ],
    
    // تنظیمات رصد گیفت‌ها
    'monitoring' => [
        'check_interval' => 3.0, // چک هر ۳ ثانیه
        'show_limited_only' => true,
        'show_available_only' => true,
        'min_stars_threshold' => 0,
        'max_stars_threshold' => 10000,
        'enable_premium_alerts' => true,
        'enable_rare_alerts' => true,
    ],
    
    // تنظیمات پیام‌ها
    'messages' => [
        'language' => 'fa',
        'timezone' => 'Asia/Tehran',
        'date_format' => 'Y/m/d',
        'time_format' => 'H:i:s',
        'use_persian_numbers' => true,
        'use_emojis' => true,
    ],
    
    // تنظیمات اطلاع‌رسانی
    'notifications' => [
        'hourly_status' => true,
        'daily_summary' => true,
        'error_alerts' => true,
        'duplicate_prevention' => true,
        'batch_sending' => true,
        'max_batch_size' => 50,
    ],
    
    // تنظیمات فایل‌ها
    'files' => [
        'users_data' => 'data/users.json',
        'bot_config' => 'data/config.json',
        'stats_file' => 'data/stats.json',
        'logs_file' => 'logs/bot.log',
        'backup_dir' => 'backup/',
        'temp_dir' => 'temp/',
    ],
    
    // تنظیمات امنیتی
    'security' => [
        'max_users' => 10000,
        'rate_limit' => 60, // پیام در دقیقه
        'blacklist_enabled' => true,
        'admin_users' => ['@TakNone'],
        'maintenance_mode' => false,
    ],
    
    // تنظیمات عملکرد
    'performance' => [
        'memory_limit' => '256M',
        'max_execution_time' => 0,
        'cache_enabled' => true,
        'compression_enabled' => true,
        'optimize_images' => false,
    ],
    
    // پیام‌های سیستم
    'system_messages' => [
        'welcome' => '🎁✨ سلام و خوش آمدید! ✨🎁',
        'maintenance' => '🔧 ربات در حال تعمیر است. لطفاً بعداً تلاش کنید.',
        'error' => '❌ خطایی رخ داده است. لطفاً مجدداً تلاش کنید.',
        'success' => '✅ عملیات با موفقیت انجام شد!',
        'unauthorized' => '🚫 شما مجاز به انجام این عملیات نیستید.',
    ],
    
    // تنظیمات بک‌آپ
    'backup' => [
        'auto_backup' => true,
        'backup_interval' => 'daily',
        'keep_backups' => 7,
        'compress_backups' => true,
    ],
    
    // تنظیمات لاگ
    'logging' => [
        'enabled' => true,
        'level' => 'info', // debug, info, warning, error
        'max_file_size' => '10MB',
        'rotate_logs' => true,
        'log_user_actions' => true,
    ],
];
