<?php

declare(strict_types=1);

// اجرای یک‌باره برای ست کردن وب‌هوک
ini_set('display_errors', '0');
error_reporting(E_ALL);

$config = require __DIR__ . '/bot_token.php';
$BOT_TOKEN = $config['BOT_TOKEN'] ?? '';
if ($BOT_TOKEN === '' || strpos($BOT_TOKEN, 'PUT_YOUR_BOT_TOKEN_HERE') !== false) {
	echo 'Bot token not configured';
	exit;
}

// اگر پارامتر url نیامده بود، به صورت خودکار آدرس webhook.php فعلی را می‌سازیم
$webhookUrl = isset($_GET['url']) ? trim($_GET['url']) : '';
if ($webhookUrl === '') {
	$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
	$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
	$dir = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')),'/');
	$webhookUrl = $scheme . '://' . $host . ($dir === '' ? '' : $dir) . '/webhook.php';
}

$api = 'https://api.telegram.org/bot' . $BOT_TOKEN . '/setWebhook';
$payload = json_encode(['url' => $webhookUrl], JSON_UNESCAPED_UNICODE);

$ch = curl_init($api);
curl_setopt_array($ch, [
	CURLOPT_RETURNTRANSFER => true,
	CURLOPT_POST => true,
	CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
	CURLOPT_POSTFIELDS => $payload,
	CURLOPT_CONNECTTIMEOUT => 10,
	CURLOPT_TIMEOUT => 20,
]);
$res = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

header('Content-Type: application/json; charset=UTF-8');
echo $res ?: json_encode(['ok'=>false,'description'=>$err ?: 'No response'], JSON_UNESCAPED_UNICODE);
