<?php

declare(strict_types=1);

// اسکریپت راه‌انداز ربات گیفت الرت

echo "🚀 در حال راه‌اندازی ربات گیفت الرت...\n\n";

// بررسی PHP version
if (version_compare(PHP_VERSION, '8.1.0') < 0) {
    echo "❌ خطا: PHP 8.1+ مورد نیاز است. نسخه فعلی: " . PHP_VERSION . "\n";
    exit(1);
}

echo "✅ نسخه PHP: " . PHP_VERSION . "\n";

// بررسی وجود فایل‌های ضروری
$requiredFiles = [
    'gift_alert_bot.php' => 'فایل اصلی ربات',
    'config.php' => 'فایل تنظیمات'
];

foreach ($requiredFiles as $file => $description) {
    if (!file_exists($file)) {
        echo "❌ خطا: $description ($file) یافت نشد!\n";
        exit(1);
    }
    echo "✅ $description موجود است\n";
}

// ایجاد دایرکتوری‌های مورد نیاز
$directories = ['data', 'logs', 'backup', 'temp'];
foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        if (!mkdir($dir, 0755, true)) {
            echo "❌ خطا در ایجاد دایرکتوری $dir\n";
            exit(1);
        }
        echo "📁 دایرکتوری $dir ایجاد شد\n";
    } else {
        echo "✅ دایرکتوری $dir موجود است\n";
    }
}

// بررسی مجوزهای نوشتن
foreach ($directories as $dir) {
    if (!is_writable($dir)) {
        echo "❌ خطا: دایرکتوری $dir قابل نوشتن نیست!\n";
        echo "💡 راه حل: chmod 755 $dir\n";
        exit(1);
    }
}

echo "✅ مجوزهای فایل بررسی شد\n";

// بررسی اتصال اینترنت
echo "🌐 بررسی اتصال اینترنت...\n";
$testUrl = 'https://api.telegram.org';
$headers = @get_headers($testUrl);
if (!$headers) {
    echo "❌ خطا: اتصال به اینترنت برقرار نیست!\n";
    exit(1);
}
echo "✅ اتصال اینترنت برقرار است\n";

// نمایش اطلاعات سیستم
echo "\n📋 اطلاعات سیستم:\n";
echo "🖥  سیستم عامل: " . PHP_OS . "\n";
echo "🧠 حافظه: " . ini_get('memory_limit') . "\n";
echo "⏱  حداکثر زمان اجرا: " . ini_get('max_execution_time') . " ثانیه\n";
echo "📅 تاریخ: " . date('Y/m/d H:i:s') . "\n";

// بارگذاری config
$config = require 'config.php';
echo "\n⚙️ تنظیمات ربات:\n";
echo "📱 نام ربات: " . $config['bot']['name'] . "\n";
echo "🔄 نسخه: " . $config['bot']['version'] . "\n";
echo "⏰ فاصله چک: " . $config['monitoring']['check_interval'] . " ثانیه\n";

// نمایش راهنمای استفاده
echo "\n📚 راهنمای استفاده:\n";
echo "1️⃣  ربات را استارت کنید\n";
echo "2️⃣  دستور @me را برای عضویت بفرستید\n";
echo "3️⃣  از /settings برای تنظیمات استفاده کنید\n";
echo "4️⃣  منتظر اطلاعیه‌های گیفت باشید!\n";

echo "\n🔧 دستورات مفید:\n";
echo "• php gift_alert_bot.php - اجرای ربات\n";
echo "• Ctrl+C - توقف ربات\n";
echo "• tail -f logs/bot.log - مشاهده لاگ‌ها\n";

// آماده‌سازی اولیه
if (!file_exists('data/users.json')) {
    file_put_contents('data/users.json', '{}');
    echo "📄 فایل کاربران ایجاد شد\n";
}

if (!file_exists('data/stats.json')) {
    $initialStats = [
        'total_sent' => 0,
        'unique_gifts' => 0,
        'start_time' => date('Y-m-d H:i:s'),
        'last_restart' => date('Y-m-d H:i:s')
    ];
    file_put_contents('data/stats.json', json_encode($initialStats, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo "📊 فایل آمار ایجاد شد\n";
}

echo "\n🎯 نکات مهم:\n";
echo "⚡️ ربات هر " . $config['monitoring']['check_interval'] . " ثانیه گیفت‌های جدید را چک می‌کند\n";
echo "💾 تمام اطلاعات در دایرکتوری data ذخیره می‌شود\n";
echo "📝 لاگ‌ها در دایرکتوری logs نگهداری می‌شود\n";
echo "🔄 بک‌آپ خودکار روزانه انجام می‌شود\n";

// هشدارهای امنیتی
echo "\n🛡  نکات امنیتی:\n";
echo "🔐 API Keys خود را محرمانه نگه دارید\n";
echo "🚫 فایل‌های config.php را public نکنید\n";
echo "🔄 به‌روزرسانی‌های امنیتی را نصب کنید\n";

echo "\n✅ همه چیز آماده است! ربات را با دستور زیر اجرا کنید:\n";
echo "🚀 php gift_alert_bot.php\n\n";

// اجرای خودکار اختیاری (فقط در CLI)
if (php_sapi_name() === 'cli') {
    echo "آیا می‌خواهید ربات را همین الان اجرا کنم؟ [y/N]: ";
    $handle = fopen("php://stdin", "r");
    $line = trim(fgets($handle));
    fclose($handle);

    if (strtolower($line) === 'y' || strtolower($line) === 'yes') {
        echo "\n🚀 اجرای ربات...\n";
        echo "برای توقف Ctrl+C را فشار دهید\n\n";
        
        // شروع لاگ
        if (!is_dir('logs')) { @mkdir('logs', 0755, true); }
        file_put_contents('logs/bot.log', "[" . date('Y-m-d H:i:s') . "] ربات شروع به کار کرد\n", FILE_APPEND);
        
        // اجرای ربات
        require_once 'gift_alert_bot.php';
    } else {
        echo "👋 برای اجرای ربات دستور 'php gift_alert_bot.php' را وارد کنید\n";
    }
} else {
    // در وب سرور، فقط گزارش را نمایش بده و خاتمه بده
    echo "\nℹ️ این صفحه فقط وضعیت اولیه را نشان می‌دهد.\n";
    echo "برای اجرای ربات، از CLI دستور زیر را اجرا کنید:\n";
    echo "php gift_alert_bot.php\n";
}

?>
