<?php

// این فایل فقط برای کمک به لاینتر است و در زمان اجرا استفاده نمی‌شود.
// اگر کلاس‌ها قبلاً توسط کتابخانه اصلی لود شده باشند، این استاب‌ها اعمال نمی‌شوند.

namespace Tak\Liveproto\Utils {
	if (!class_exists(Settings::class)) {
		class Settings {
			public function setApiId(int $id): void {}
			public function setApiHash(string $hash): void {}
			public function setDeviceModel(string $model): void {}
			public function setSystemVersion(string $version): void {}
			public function setAppVersion(string $version): void {}
			public function setIPv6(bool $v): void {}
			public function setHideLog(bool $v): void {}
			public function setReceiveUpdates(bool $v): void {}
		}
	}
}

namespace Tak\Liveproto\Network {
	use Tak\Liveproto\Utils\Settings;
	if (!class_exists(Client::class)) {
		class Client {
			public bool $connected = true;
			public object $messages;
			public object $payments;
			public function __construct(string $session, string $storage, Settings $settings) {
				$this->messages = new class {
					public function sendMessageMultiple(...$args): void {}
				};
				$this->payments = new class {
					public function getStarGifts(int $hash = 0): object { return (object)['hash'=>1,'gifts'=>[], 'getClass'=>fn()=>'payments.starGifts']; }
				};
			}
			public function addHandler(object $handler): void {}
			public function start(): void {}
			public function isAuthorized(): bool { return true; }
			public function get_input_peer(mixed $peer): mixed { return $peer; }
		}
	}
}

namespace Revolt {
	if (!class_exists(EventLoop::class)) {
		class EventLoop {
			public static function repeat(float $interval, callable $callback): mixed { return null; }
			public static function unreference(mixed $watcher): void {}
		}
	}
}

namespace Tak\Liveproto\Filters\Events {
	if (!class_exists(NewMessage::class)) {
		class NewMessage { public function __construct(mixed $x = null) {} }
	}
}

namespace Tak\Liveproto\Filters\Filter {
	if (!class_exists(Command::class)) {
		class Command { public function __construct(mixed ...$args) {} }
	}
}

namespace Tak\Liveproto\Filters {
	if (!class_exists(Filter::class)) {
		#[\Attribute(\Attribute::TARGET_METHOD)]
		class Filter { public function __construct(mixed ...$args) {} }
	}
}

namespace Tak\Liveproto\Enums {
	if (!class_exists(CommandType::class)) {
		class CommandType {
			public const SLASH = 1;
			public const DOT = 2;
			public const EXCLAMATION = 3;
			public const AT = 4;
		}
	}
}
