<?php

declare(strict_types=1);

// وب‌هوک Bot API - سازگار با هاست cPanel
// این اسکریپت باید از طریق HTTPS فراخوانی شود

// خطایابی نرم برای هاست اشتراکی
ini_set('display_errors', '0');
error_reporting(E_ALL);

// توکن ربات
$config = require __DIR__ . '/bot_token.php';
$BOT_TOKEN = $config['BOT_TOKEN'] ?? '';
if ($BOT_TOKEN === '' || strpos($BOT_TOKEN, 'PUT_YOUR_BOT_TOKEN_HERE') !== false) {
	http_response_code(500);
	echo 'Bot token not configured';
	exit;
}

$API = 'https://api.telegram.org/bot' . $BOT_TOKEN . '/';

// مسیرهای فایل داده
$USERS_FILE = __DIR__ . '/data/users.json';

function load_users(string $path): array {
	if (!is_file($path)) { return []; }
	$json = file_get_contents($path);
	return json_decode($json, true) ?: [];
}

function save_users(string $path, array $users): void {
	$dir = dirname($path);
	if (!is_dir($dir)) { @mkdir($dir, 0755, true); }
	file_put_contents($path, json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// دریافت بدنه JSON
$raw = file_get_contents('php://input');
$update = json_decode($raw ?: '[]', true);

// کمک کننده ساده برای ارسال درخواست به Bot API
function tg_call(string $method, array $params): array {
	global $API;
	$ch = curl_init($API . $method);
	curl_setopt_array($ch, [
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_POST => true,
		CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
		CURLOPT_POSTFIELDS => json_encode($params, JSON_UNESCAPED_UNICODE),
		CURLOPT_CONNECTTIMEOUT => 10,
		CURLOPT_TIMEOUT => 15,
	]);
	$res = curl_exec($ch);
	if ($res === false) {
		$err = curl_error($ch);
		curl_close($ch);
		return ['ok' => false, 'description' => $err];
	}
	curl_close($ch);
	return json_decode($res, true) ?: ['ok' => false, 'description' => 'bad json'];
}

function sendMessage(int $chatId, string $text, array $opts = []): void {
	$params = array_merge([
		'chat_id' => $chatId,
		'text' => $text,
		'parse_mode' => 'HTML'
	], $opts);
	tg_call('sendMessage', $params);
}

// ارسال با کیبورد شیشه‌ای (Inline Keyboard)
function sendMessageWithInlineKeyboard(int $chatId, string $text, array $buttons): void {
	$replyMarkup = ['inline_keyboard' => $buttons];
	tg_call('sendMessage', [
		'chat_id' => $chatId,
		'text' => $text,
		'parse_mode' => 'HTML',
		'reply_markup' => $replyMarkup
	]);
}

// پاسخ به کلیک دکمه‌های شیشه‌ای
function answerCallbackQuery(string $callbackId, string $text = '', bool $showAlert = false): void {
	tg_call('answerCallbackQuery', [
		'callback_query_id' => $callbackId,
		'text' => $text,
		'show_alert' => $showAlert
	]);
}

// پردازش آپدیت
if (!empty($update['message'])) {
	$msg = $update['message'];
	$chatId = (int)($msg['chat']['id'] ?? 0);
	$text = trim((string)($msg['text'] ?? ''));
    $users = load_users($USERS_FILE);

	if ($chatId !== 0 && $text !== '') {
		$lower = mb_strtolower($text, 'UTF-8');
		if ($lower === '/start' || $lower === 'start') {
			$welcome = "🎁✨ سلام! خوش اومدی به ربات شیشه‌ای گیفت الرت! ✨🎁\n\n";
			$welcome .= "🔥 این ربات گیفت‌های جدید تلگرام رو بهت اطلاع میده!\n\n";
			$welcome .= "✨ دستورات خفن:\n";
			$welcome .= "🚀 /start - شروع ماجراجویی\n";
			$welcome .= "💎 /me - عضویت VIP برای نوتیف\n";
			$welcome .= "⚙️ /settings - تنظیمات شخصی\n";
			$welcome .= "📊 /stats - آمار لحظه‌ای\n";
			$welcome .= "🔔 /toggle_notifications - تغییر وضعیت اطلاعیه\n";
			$welcome .= "❓ /help - راهنمای کامل\n\n";
			$welcome .= "🎯 برای شروع /me رو بزن و وارد دنیای گیفت‌ها شو! 🚀";
			sendMessageWithInlineKeyboard($chatId, $welcome, [
				[
					['text' => '💎 عضویت VIP (/me)', 'callback_data' => 'noop_me'],
					['text' => '⚙️ تنظیمات', 'callback_data' => 'noop_settings']
				],
				[
					['text' => '📊 آمار', 'callback_data' => 'noop_stats'],
					['text' => '❓ راهنما', 'callback_data' => 'noop_help']
				]
			]);
			goto end;
		}
		if ($lower === '/me' || $lower === 'me' || $lower === '@me') {
			$isNew = !isset($users[(string)$chatId]);
			$users[(string)$chatId] = [
				'username' => (string)($msg['from']['username'] ?? 'کاربر_' . $chatId),
				'first_name' => (string)($msg['from']['first_name'] ?? ''),
				'joined_at' => date('Y-m-d H:i:s'),
				'notifications' => true,
				'alert_types' => ['limited','premium','rare']
			];
			save_users($USERS_FILE, $users);
			
			if ($isNew) {
				$response = "🎉✨ باحال! به خانواده VIP ما خوش اومدی! ✨🎉\n\n";
				$response .= "💎 از الان گیفت‌های خفن تلگرام رو زودتر از همه میدونی!\n";
				$response .= "🔔 اطلاعیه‌ها: فعال\n";
				$response .= "🎁 انواع گیفت: محدود، پریمیوم، نادر\n\n";
				$response .= "⚙️ برای تنظیمات بیشتر /settings رو بزن!";
			} else {
				$response = "✅ عالی! قبلاً عضو بودی، تنظیماتت به‌روزرسانی شد! 🔥";
			}
			sendMessage($chatId, $response);
			goto end;
		}
		if ($lower === '/settings') {
			$u = $users[(string)$chatId] ?? null;
			if (!$u) {
				sendMessage($chatId, "❌ ابتدا با /me عضو شو!");
				goto end;
			}
			
			$notif = $u['notifications'] ?? false ? '✅ فعال' : '❌ غیرفعال';
			$types = $u['alert_types'] ?? [];
			$limited = in_array('limited', $types) ? '✅' : '❌';
			$premium = in_array('premium', $types) ? '✅' : '❌';
			$rare = in_array('rare', $types) ? '✅' : '❌';
			
			$settings = "⚙️✨ تنظیمات شخصی شما ✨⚙️\n\n";
			$settings .= "👤 نام: " . ($u['first_name'] ?: $u['username'] ?: 'ناشناس') . "\n";
			$settings .= "📅 عضو از: " . ($u['joined_at'] ?? 'نامشخص') . "\n\n";
			$settings .= "🔔 اطلاعیه‌ها: $notif\n";
			$settings .= "🎁 گیفت محدود: $limited\n";
			$settings .= "💎 گیفت پریمیوم: $premium\n";
			$settings .= "⭐ گیفت نادر: $rare\n\n";
			$settings .= "🔧 دستورات تنظیم:\n";
			$settings .= "/toggle_notifications - فعال/غیرفعال اطلاعیه\n";
			$settings .= "/toggle_limited - گیفت‌های محدود\n";
			$settings .= "/toggle_premium - گیفت‌های پریمیوم";
			
			sendMessage($chatId, $settings);
			goto end;
		}
		if ($lower === '/toggle_notifications') {
			if (!isset($users[(string)$chatId])) {
				sendMessage($chatId, "❌ ابتدا با /me عضو شو!");
				goto end;
			}
			
			$u = $users[(string)$chatId];
			$u['notifications'] = !($u['notifications'] ?? false);
			$users[(string)$chatId] = $u;
			save_users($USERS_FILE, $users);
			
			$emoji = $u['notifications'] ? '🔔✅' : '🔕❌';
			$status = $u['notifications'] ? 'فعال شد!' : 'غیرفعال شد!';
			sendMessage($chatId, "$emoji اطلاعیه‌ها $status\n\n" . 
				($u['notifications'] ? "🎉 از الان گیفت‌های جدید رو زودتر از همه میدونی!" : "😴 دیگه اطلاعیه دریافت نمی‌کنی. با همین دستور دوباره فعال کن!"));
			goto end;
		}
		if ($lower === '/stats') {
			$totalUsers = count($users);
			$activeUsers = count(array_filter($users, fn($u) => $u['notifications'] ?? false));
			
			$stats = "📊✨ آمار شیشه‌ای ربات ✨📊\n\n";
			$stats .= "🤖 وضعیت: 🟢 آنلاین و خفن!\n";
			$stats .= "👥 کل اعضا: $totalUsers نفر\n";
			$stats .= "🔔 اعضای فعال: $activeUsers نفر\n";
			$stats .= "📅 تاریخ: " . date('Y/m/d') . "\n";
			$stats .= "🕐 ساعت: " . date('H:i:s') . "\n\n";
			$stats .= "🚀 ربات ۲۴/۷ در حال رصد گیفت‌های جدید!";
			
			sendMessage($chatId, $stats);
			goto end;
		}
		if ($lower === '/help') {
			$help = "📚✨ راهنمای کامل ربات شیشه‌ای ✨📚\n\n";
			$help .= "🎯 دستورات اصلی:\n";
			$help .= "🚀 /start - شروع و خوش‌آمدگویی\n";
			$help .= "💎 /me - عضویت VIP\n";
			$help .= "⚙️ /settings - مشاهده تنظیمات\n";
			$help .= "📊 /stats - آمار ربات\n";
			$help .= "❓ /help - این راهنما\n\n";
			$help .= "🔧 دستورات تنظیم:\n";
			$help .= "🔔 /toggle_notifications - فعال/غیرفعال اطلاعیه\n\n";
			$help .= "🎁 درباره گیفت‌ها:\n";
			$help .= "این ربات گیفت‌های جدید تلگرام رو رصد می‌کنه\n";
			$help .= "و بلافاصله بهت اطلاع میده!\n\n";
			$help .= "💡 نکات مهم:\n";
			$help .= "• فقط گیفت‌های محدود و خاص نمایش داده میشن\n";
			$help .= "• قیمت‌ها بر اساس Telegram Stars هست\n";
			$help .= "• اطلاعیه‌ها فوری و آنی ارسال میشن\n\n";
			$help .= "🔥 ساخته شده با عشق و کد خفن!";
			sendMessageWithInlineKeyboard($chatId, $help, [
				[
					['text' => '💎 عضویت', 'callback_data' => 'noop_me'],
					['text' => '⚙️ تنظیمات', 'callback_data' => 'noop_settings']
				],
				[
					['text' => '📊 آمار', 'callback_data' => 'noop_stats'],
					['text' => '🔔 تغییر اطلاعیه', 'callback_data' => 'noop_toggle']
				]
			]);
			
			goto end;
		}
		// پاسخ پیش‌فرض شیشه‌ای
		$randomResponses = [
			"🤔 متوجه نشدم! از /help استفاده کن تا راهنما رو ببینی! 📚",
			"🚀 دستور جالبی بود ولی نمی‌شناسم! /help رو بزن! ⚡",
			"✨ چیز خفنی نوشتی ولی من نمی‌فهمم! از /help کمک بگیر! 🔥",
			"💎 این دستور رو بلد نیستم! /help رو چک کن! 🎯"
		];
		$response = $randomResponses[array_rand($randomResponses)];
		sendMessage($chatId, $response);
	}
}

// هندلر دکمه‌های شیشه‌ای (callback_query)
if (!empty($update['callback_query'])) {
	$cb = $update['callback_query'];
	$callbackId = (string)($cb['id'] ?? '');
	$data = (string)($cb['data'] ?? '');
	$chatId = (int)($cb['message']['chat']['id'] ?? ($cb['from']['id'] ?? 0));
	$users = load_users($USERS_FILE);

	if ($chatId !== 0 && $data !== '') {
		switch ($data) {
			case 'noop_me': {
				$isNew = !isset($users[(string)$chatId]);
				$users[(string)$chatId] = [
					'username' => (string)($cb['from']['username'] ?? 'کاربر_' . $chatId),
					'first_name' => (string)($cb['from']['first_name'] ?? ''),
					'joined_at' => date('Y-m-d H:i:s'),
					'notifications' => true,
					'alert_types' => ['limited','premium','rare']
				];
				save_users($USERS_FILE, $users);
				answerCallbackQuery($callbackId, $isNew ? 'عضویت انجام شد ✅' : 'قبلاً عضو بودی ✅');
				sendMessage($chatId, $isNew
					? "🎉✨ باحال! به خانواده VIP ما خوش اومدی!"
					: "✅ عالی! قبلاً عضو بودی، تنظیماتت به‌روزرسانی شد! 🔥");
				break;
			}
			case 'noop_settings': {
				$u = $users[(string)$chatId] ?? null;
				if (!$u) { answerCallbackQuery($callbackId, 'اول /me رو بزن'); break; }
				$notif = $u['notifications'] ?? false ? '✅ فعال' : '❌ غیرفعال';
				$types = $u['alert_types'] ?? [];
				$limited = in_array('limited', $types) ? '✅' : '❌';
				$premium = in_array('premium', $types) ? '✅' : '❌';
				$rare = in_array('rare', $types) ? '✅' : '❌';
				$settings = "⚙️✨ تنظیمات شخصی شما ✨⚙️\n\n" .
					"🔔 اطلاعیه‌ها: $notif\n" .
					"🎁 محدود: $limited | 💎 پریمیوم: $premium | ⭐ نادر: $rare";
				answerCallbackQuery($callbackId, 'تنظیمات');
				sendMessageWithInlineKeyboard($chatId, $settings, [
					[
						['text' => '🔔 تغییر اطلاعیه', 'callback_data' => 'noop_toggle'],
						['text' => '📊 آمار', 'callback_data' => 'noop_stats']
					]
				]);
				break;
			}
			case 'noop_stats': {
				$totalUsers = count($users);
				$activeUsers = count(array_filter($users, fn($u) => $u['notifications'] ?? false));
				$stats = "📊✨ آمار شیشه‌ای ربات ✨📊\n\n" .
					"👥 کل اعضا: $totalUsers\n" .
					"🔔 فعال: $activeUsers\n" .
					"📅 تاریخ: " . date('Y/m/d') . "\n" .
					"🕐 ساعت: " . date('H:i:s');
				answerCallbackQuery($callbackId, 'آمار');
				sendMessage($chatId, $stats);
				break;
			}
			case 'noop_help': {
				answerCallbackQuery($callbackId, 'راهنما');
				sendMessage($chatId, "📚 /start /me /settings /stats /help");
				break;
			}
			case 'noop_toggle': {
				$u = $users[(string)$chatId] ?? null;
				if (!$u) { answerCallbackQuery($callbackId, 'اول /me رو بزن'); break; }
				$u['notifications'] = !($u['notifications'] ?? false);
				$users[(string)$chatId] = $u;
				save_users($USERS_FILE, $users);
				answerCallbackQuery($callbackId, $u['notifications'] ? 'فعال شد ✅' : 'غیرفعال شد ❌');
				sendMessage($chatId, $u['notifications'] ? '🔔 اطلاعیه‌ها فعال شد' : '🔕 اطلاعیه‌ها غیرفعال شد');
				break;
			}
			default:
				answerCallbackQuery($callbackId);
		}
	}
}

end:
http_response_code(200);
echo 'OK';
