# 🎁✨ آموزش کامل ربات شیشه‌ای گیفت الرت ✨🎁

## 🚀 مقدمه

این ربات خفن برای اطلاع‌رسانی گیفت‌های جدید تلگرام طراحی شده! دو نسخه داره:

1. **نسخه CLI (gift_alert_bot.php)** - برای سرورهای مجازی با دسترسی CLI
2. **نسخه وب‌هوک (webhook.php)** - برای هاست‌های cPanel بدون CLI ✅

## 📱 تنظیم توکن ربات

### گام 1: ایجاد ربات جدید

1. به [@BotFather](https://t.me/BotFather) در تلگرام برو
2. دستور `/newbot` رو بفرست
3. اسم ربات رو انتخاب کن (مثلاً: Gift Alert Bot)
4. یوزرنیم ربات رو انتخاب کن (باید به `_bot` ختم شه)
5. توکن رو کپی کن (مثل: `123456789:AAH...`)

### گام 2: تنظیم توکن در فایل‌ها

#### برای نسخه وب‌هوک (cPanel):
فایل `bot_token.php` رو باز کن و توکن رو جایگزین کن:

```php
<?php
return [
    'BOT_TOKEN' => '8347736545:AAHEMiX-1wm6jNCAtj2U8SBnixcT9QLEYM4'  // توکن واقعی شما
];
```

#### برای نسخه CLI:
فایل `config.php` رو باز کن و در بخش تلگرام، api_id و api_hash خودت رو بذار:

```php
'telegram' => [
    'api_id' => 26575668,           // API ID خودت
    'api_hash' => '5b883684efd9b2b681e2b7e1e98c2e10',  // API Hash خودت
    // ...
],
```

**نکته مهم:** API ID و Hash از [my.telegram.org](https://my.telegram.org) بگیر (نه BotFather)

## 🌐 راه‌اندازی نسخه وب‌هوک (برای cPanel)

### گام 1: آپلود فایل‌ها
فایل‌های زیر رو روی هاست آپلود کن:
- `webhook.php` (هندلر اصلی)
- `bot_token.php` (توکن ربات)
- `set_webhook.php` (تنظیم وب‌هوک)

### گام 2: تنظیم مجوزها
```
chmod 755 data/
chmod 644 data/*.json
```

### گام 3: تنظیم وب‌هوک
این لینک رو در مرورگر باز کن:
```
https://دامنه-شما.com/مسیر-ربات/set_webhook.php
```

مثال:
```
https://moein.s6.vipbotdomain.top/bot/set_webhook.php
```

باید پیام `{"ok":true,"result":true,"description":"Webhook was set"}` رو ببینی.

### گام 4: تست ربات
به ربات تو تلگرام پیام بده:
- `/start` - شروع
- `/me` - عضویت برای نوتیف
- `/settings` - مشاهده تنظیمات

## 🖥️ راه‌اندازی نسخه CLI (برای سرور مجازی)

### گام 1: نصب وابستگی‌ها
```bash
php start.php
```

### گام 2: اجرای ربات
```bash
php gift_alert_bot.php
```

## ⚙️ تنظیمات پیشرفته در config.php

### تنظیم فاصله چک گیفت‌ها:
```php
'monitoring' => [
    'check_interval' => 3.0,  // هر 3 ثانیه (کم کن اگر سرور قوی داری)
    'show_limited_only' => true,  // فقط گیفت‌های محدود
    'show_available_only' => true,  // فقط گیفت‌های موجود
],
```

### تنظیم اطلاعیه‌ها:
```php
'notifications' => [
    'hourly_status' => true,  // گزارش ساعتی
    'daily_summary' => true,  // خلاصه روزانه
    'duplicate_prevention' => true,  // جلوگیری از تکرار
],
```

### تنظیم امنیت:
```php
'security' => [
    'max_users' => 10000,  // حداکثر کاربر
    'admin_users' => ['@your_username'],  // ادمین‌ها
    'maintenance_mode' => false,  // حالت تعمیر
],
```

## 🎯 دستورات ربات شیشه‌ای

| دستور | توضیح |
|--------|-------|
| `/start` | شروع و خوش‌آمدگویی شیشه‌ای |
| `/me` | عضویت VIP برای نوتیف گیفت‌ها |
| `/settings` | مشاهده تنظیمات شخصی |
| `/stats` | آمار لحظه‌ای ربات |
| `/toggle_notifications` | فعال/غیرفعال اطلاعیه‌ها |
| `/help` | راهنمای کامل |

## 🔧 عیب‌یابی مشکلات رایج

### مشکل 1: ربات پاسخ نمیده
- چک کن توکن درست باشه
- مطمئن شو وب‌هوک ست شده (برای نسخه وب‌هوک)
- لاگ‌های سرور رو بررسی کن

### مشکل 2: خطای مجوز فایل
```bash
chmod 755 data/
chmod 644 data/*.json
```

### مشکل 3: خطای Composer (PHP >= 8.3)
فقط نسخه وب‌هوک رو استفاده کن! نیازی به Composer نداره.

### مشکل 4: وب‌هوک کار نمی‌کنه
- مطمئن شو HTTPS فعال باشه
- چک کن فایل webhook.php در دسترس باشه
- وضعیت وب‌هوک رو با این لینک چک کن:
```
https://api.telegram.org/bot<TOKEN>/getWebhookInfo
```

## 📊 مدیریت داده‌ها

### مسیر فایل‌های داده:
- `data/users.json` - اطلاعات کاربران
- `data/config.json` - تنظیمات ربات
- `data/stats.json` - آمار

### بک‌آپ دستی:
```bash
php manage.php backup
```

### مشاهده آمار:
```bash
php manage.php stats
```

## 🎨 شخصی‌سازی ربات

### تغییر متن‌های ربات:
فایل `webhook.php` رو باز کن و متن‌های داخل قسمت‌های مختلف رو تغییر بده.

### اضافه کردن دستور جدید:
```php
if ($lower === '/mydcommand') {
    sendMessage($chatId, '🎉 دستور جدید!');
    goto end;
}
```

## 🔐 نکات امنیتی

1. **محافظت از توکن:**
   - توکن رو در فایل‌های عمومی قرار نده
   - از .gitignore استفاده کن

2. **محدودیت دسترسی:**
   - فایل‌های حساس رو خارج از public_html قرار بده
   - مجوزهای فایل رو درست تنظیم کن

3. **مانیتورینگ:**
   - لاگ‌ها رو بررسی کن
   - ترافیک غیرعادی رو رصد کن

## 🚀 بهینه‌سازی عملکرد

### برای هاست اشتراکی:
- فاصله چک رو بالا ببر (5-10 ثانیه)
- حافظه PHP رو چک کن
- از cache استفاده کن

### برای سرور مجازی:
- فاصله چک رو پایین بیار (1-3 ثانیه)
- چندتا instance همزمان اجرا کن
- از Redis برای cache استفاده کن

## 📞 پشتیبانی

اگر مشکلی داشتی:

1. **لاگ‌ها رو بررسی کن:**
   - برای CLI: `tail -f logs/bot.log`
   - برای cPanel: Error Logs در cPanel

2. **تست کن:**
   - webhook.php رو مستقیم در مرورگر باز کن
   - باید "OK" نشون بده

3. **کمک بگیر:**
   - GitHub Issues
   - تلگرام: [@TakNone](https://t.me/TakNone)

## 🎉 موفقیت!

اگر همه چیز درست پیش رفت:
- ربات باید به پیام‌ها پاسخ بده
- کاربران با `/me` عضو بشن
- اطلاعیه‌های گیفت ارسال شه

**تبریک! ربات شیشه‌ای شما آماده است! 🔥✨**

---

*ساخته شده با ❤️ و کد خفن برای جامعه ایرانی*
